// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Strategy of translating required query parameters to template ones. By default has value 'template'. Possible values: 'template', 'query'. </summary>
    public readonly partial struct TranslateRequiredQueryParametersConduct : IEquatable<TranslateRequiredQueryParametersConduct>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TranslateRequiredQueryParametersConduct"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TranslateRequiredQueryParametersConduct(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TemplateValue = "template";
        private const string QueryValue = "query";

        /// <summary> Translates required query parameters to template ones. Is a default value. </summary>
        public static TranslateRequiredQueryParametersConduct Template { get; } = new TranslateRequiredQueryParametersConduct(TemplateValue);
        /// <summary> Leaves required query parameters as they are (no translation done). </summary>
        public static TranslateRequiredQueryParametersConduct Query { get; } = new TranslateRequiredQueryParametersConduct(QueryValue);
        /// <summary> Determines if two <see cref="TranslateRequiredQueryParametersConduct"/> values are the same. </summary>
        public static bool operator ==(TranslateRequiredQueryParametersConduct left, TranslateRequiredQueryParametersConduct right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TranslateRequiredQueryParametersConduct"/> values are not the same. </summary>
        public static bool operator !=(TranslateRequiredQueryParametersConduct left, TranslateRequiredQueryParametersConduct right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TranslateRequiredQueryParametersConduct"/>. </summary>
        public static implicit operator TranslateRequiredQueryParametersConduct(string value) => new TranslateRequiredQueryParametersConduct(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TranslateRequiredQueryParametersConduct other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TranslateRequiredQueryParametersConduct other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
