// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> The verbosity level applied to traces emitted by trace policies. </summary>
    public readonly partial struct TraceVerbosityLevel : IEquatable<TraceVerbosityLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TraceVerbosityLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TraceVerbosityLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string VerboseValue = "verbose";
        private const string InformationValue = "information";
        private const string ErrorValue = "error";

        /// <summary> All the traces emitted by trace policies will be sent to the logger attached to this diagnostic instance. </summary>
        public static TraceVerbosityLevel Verbose { get; } = new TraceVerbosityLevel(VerboseValue);
        /// <summary> Traces with 'severity' set to 'information' and 'error' will be sent to the logger attached to this diagnostic instance. </summary>
        public static TraceVerbosityLevel Information { get; } = new TraceVerbosityLevel(InformationValue);
        /// <summary> Only traces with 'severity' set to 'error' will be sent to the logger attached to this diagnostic instance. </summary>
        public static TraceVerbosityLevel Error { get; } = new TraceVerbosityLevel(ErrorValue);
        /// <summary> Determines if two <see cref="TraceVerbosityLevel"/> values are the same. </summary>
        public static bool operator ==(TraceVerbosityLevel left, TraceVerbosityLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TraceVerbosityLevel"/> values are not the same. </summary>
        public static bool operator !=(TraceVerbosityLevel left, TraceVerbosityLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TraceVerbosityLevel"/>. </summary>
        public static implicit operator TraceVerbosityLevel(string value) => new TraceVerbosityLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TraceVerbosityLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TraceVerbosityLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
