// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Result of Tenant Configuration Sync State. </summary>
    public partial class TenantConfigurationSyncStateContract : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TenantConfigurationSyncStateContract"/>. </summary>
        public TenantConfigurationSyncStateContract()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TenantConfigurationSyncStateContract"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="branch"> The name of Git branch. </param>
        /// <param name="commitId"> The latest commit Id. </param>
        /// <param name="isExported"> value indicating if last sync was save (true) or deploy (false) operation. </param>
        /// <param name="isSynced"> value indicating if last synchronization was later than the configuration change. </param>
        /// <param name="isGitEnabled"> value indicating whether Git configuration access is enabled. </param>
        /// <param name="syncOn">
        /// The date of the latest synchronization. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </param>
        /// <param name="configurationChangeOn">
        /// The date of the latest configuration change. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </param>
        /// <param name="lastOperationId"> Most recent tenant configuration operation identifier. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TenantConfigurationSyncStateContract(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string branch, string commitId, bool? isExported, bool? isSynced, bool? isGitEnabled, DateTimeOffset? syncOn, DateTimeOffset? configurationChangeOn, string lastOperationId, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Branch = branch;
            CommitId = commitId;
            IsExported = isExported;
            IsSynced = isSynced;
            IsGitEnabled = isGitEnabled;
            SyncOn = syncOn;
            ConfigurationChangeOn = configurationChangeOn;
            LastOperationId = lastOperationId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of Git branch. </summary>
        [WirePath("properties.branch")]
        public string Branch { get; set; }
        /// <summary> The latest commit Id. </summary>
        [WirePath("properties.commitId")]
        public string CommitId { get; set; }
        /// <summary> value indicating if last sync was save (true) or deploy (false) operation. </summary>
        [WirePath("properties.isExport")]
        public bool? IsExported { get; set; }
        /// <summary> value indicating if last synchronization was later than the configuration change. </summary>
        [WirePath("properties.isSynced")]
        public bool? IsSynced { get; set; }
        /// <summary> value indicating whether Git configuration access is enabled. </summary>
        [WirePath("properties.isGitEnabled")]
        public bool? IsGitEnabled { get; set; }
        /// <summary>
        /// The date of the latest synchronization. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </summary>
        [WirePath("properties.syncDate")]
        public DateTimeOffset? SyncOn { get; set; }
        /// <summary>
        /// The date of the latest configuration change. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </summary>
        [WirePath("properties.configurationChangeDate")]
        public DateTimeOffset? ConfigurationChangeOn { get; set; }
        /// <summary> Most recent tenant configuration operation identifier. </summary>
        [WirePath("properties.lastOperationId")]
        public string LastOperationId { get; set; }
    }
}
