// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ApiManagement.Models
{
    internal static partial class SubscriptionStateExtensions
    {
        public static string ToSerialString(this SubscriptionState value) => value switch
        {
            SubscriptionState.Suspended => "suspended",
            SubscriptionState.Active => "active",
            SubscriptionState.Expired => "expired",
            SubscriptionState.Submitted => "submitted",
            SubscriptionState.Rejected => "rejected",
            SubscriptionState.Cancelled => "cancelled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SubscriptionState value.")
        };

        public static SubscriptionState ToSubscriptionState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "suspended")) return SubscriptionState.Suspended;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "active")) return SubscriptionState.Active;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "expired")) return SubscriptionState.Expired;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "submitted")) return SubscriptionState.Submitted;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "rejected")) return SubscriptionState.Rejected;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "cancelled")) return SubscriptionState.Cancelled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SubscriptionState value.");
        }
    }
}
