// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> The type of access to be used for the storage account. </summary>
    public readonly partial struct StorageAccountAccessType : IEquatable<StorageAccountAccessType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageAccountAccessType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageAccountAccessType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AccessKeyValue = "AccessKey";
        private const string SystemAssignedManagedIdentityValue = "SystemAssignedManagedIdentity";
        private const string UserAssignedManagedIdentityValue = "UserAssignedManagedIdentity";

        /// <summary> Use access key. </summary>
        public static StorageAccountAccessType AccessKey { get; } = new StorageAccountAccessType(AccessKeyValue);
        /// <summary> Use system assigned managed identity. </summary>
        public static StorageAccountAccessType SystemAssignedManagedIdentity { get; } = new StorageAccountAccessType(SystemAssignedManagedIdentityValue);
        /// <summary> Use user assigned managed identity. </summary>
        public static StorageAccountAccessType UserAssignedManagedIdentity { get; } = new StorageAccountAccessType(UserAssignedManagedIdentityValue);
        /// <summary> Determines if two <see cref="StorageAccountAccessType"/> values are the same. </summary>
        public static bool operator ==(StorageAccountAccessType left, StorageAccountAccessType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageAccountAccessType"/> values are not the same. </summary>
        public static bool operator !=(StorageAccountAccessType left, StorageAccountAccessType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageAccountAccessType"/>. </summary>
        public static implicit operator StorageAccountAccessType(string value) => new StorageAccountAccessType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageAccountAccessType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageAccountAccessType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
