// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Sampling type. </summary>
    public readonly partial struct SamplingType : IEquatable<SamplingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SamplingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SamplingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FixedValue = "fixed";

        /// <summary> Fixed-rate sampling. </summary>
        public static SamplingType Fixed { get; } = new SamplingType(FixedValue);
        /// <summary> Determines if two <see cref="SamplingType"/> values are the same. </summary>
        public static bool operator ==(SamplingType left, SamplingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SamplingType"/> values are not the same. </summary>
        public static bool operator !=(SamplingType left, SamplingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SamplingType"/>. </summary>
        public static implicit operator SamplingType(string value) => new SamplingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SamplingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SamplingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
