// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Sampling settings for Diagnostic. </summary>
    public partial class SamplingSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SamplingSettings"/>. </summary>
        public SamplingSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SamplingSettings"/>. </summary>
        /// <param name="samplingType"> Sampling type. </param>
        /// <param name="percentage"> Rate of sampling for fixed-rate sampling. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SamplingSettings(SamplingType? samplingType, double? percentage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SamplingType = samplingType;
            Percentage = percentage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Sampling type. </summary>
        [WirePath("samplingType")]
        public SamplingType? SamplingType { get; set; }
        /// <summary> Rate of sampling for fixed-rate sampling. </summary>
        [WirePath("percentage")]
        public double? Percentage { get; set; }
    }
}
