// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Resource location data properties. </summary>
    public partial class ResourceLocationDataContract
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceLocationDataContract"/>. </summary>
        /// <param name="name"> A canonical name for the geographic or physical location. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public ResourceLocationDataContract(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceLocationDataContract"/>. </summary>
        /// <param name="name"> A canonical name for the geographic or physical location. </param>
        /// <param name="city"> The city or locality where the resource is located. </param>
        /// <param name="district"> The district, state, or province where the resource is located. </param>
        /// <param name="countryOrRegion"> The country or region where the resource is located. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceLocationDataContract(string name, string city, string district, string countryOrRegion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            City = city;
            District = district;
            CountryOrRegion = countryOrRegion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceLocationDataContract"/> for deserialization. </summary>
        internal ResourceLocationDataContract()
        {
        }

        /// <summary> A canonical name for the geographic or physical location. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> The city or locality where the resource is located. </summary>
        [WirePath("city")]
        public string City { get; set; }
        /// <summary> The district, state, or province where the resource is located. </summary>
        [WirePath("district")]
        public string District { get; set; }
        /// <summary> The country or region where the resource is located. </summary>
        [WirePath("countryOrRegion")]
        public string CountryOrRegion { get; set; }
    }
}
