// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Operation request/response representation details. </summary>
    public partial class RepresentationContract
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RepresentationContract"/>. </summary>
        /// <param name="contentType"> Specifies a registered or custom content type for this representation, e.g. application/xml. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="contentType"/> is null. </exception>
        public RepresentationContract(string contentType)
        {
            Argument.AssertNotNull(contentType, nameof(contentType));

            ContentType = contentType;
            FormParameters = new ChangeTrackingList<ParameterContract>();
            Examples = new ChangeTrackingDictionary<string, ParameterExampleContract>();
        }

        /// <summary> Initializes a new instance of <see cref="RepresentationContract"/>. </summary>
        /// <param name="contentType"> Specifies a registered or custom content type for this representation, e.g. application/xml. </param>
        /// <param name="schemaId"> Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'. </param>
        /// <param name="typeName"> Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'. </param>
        /// <param name="formParameters"> Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'.. </param>
        /// <param name="examples"> Exampled defined for the representation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RepresentationContract(string contentType, string schemaId, string typeName, IList<ParameterContract> formParameters, IDictionary<string, ParameterExampleContract> examples, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ContentType = contentType;
            SchemaId = schemaId;
            TypeName = typeName;
            FormParameters = formParameters;
            Examples = examples;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RepresentationContract"/> for deserialization. </summary>
        internal RepresentationContract()
        {
        }

        /// <summary> Specifies a registered or custom content type for this representation, e.g. application/xml. </summary>
        [WirePath("contentType")]
        public string ContentType { get; set; }
        /// <summary> Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'. </summary>
        [WirePath("schemaId")]
        public string SchemaId { get; set; }
        /// <summary> Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'. </summary>
        [WirePath("typeName")]
        public string TypeName { get; set; }
        /// <summary> Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'.. </summary>
        [WirePath("formParameters")]
        public IList<ParameterContract> FormParameters { get; }
        /// <summary> Exampled defined for the representation. </summary>
        [WirePath("examples")]
        public IDictionary<string, ParameterExampleContract> Examples { get; }
    }
}
