// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> The IP version to be used. Only IPv4 is supported for now. </summary>
    public readonly partial struct PreferredIPVersion : IEquatable<PreferredIPVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PreferredIPVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PreferredIPVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IPv4Value = "IPv4";

        /// <summary> IPv4. </summary>
        public static PreferredIPVersion IPv4 { get; } = new PreferredIPVersion(IPv4Value);
        /// <summary> Determines if two <see cref="PreferredIPVersion"/> values are the same. </summary>
        public static bool operator ==(PreferredIPVersion left, PreferredIPVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PreferredIPVersion"/> values are not the same. </summary>
        public static bool operator !=(PreferredIPVersion left, PreferredIPVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PreferredIPVersion"/>. </summary>
        public static implicit operator PreferredIPVersion(string value) => new PreferredIPVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PreferredIPVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PreferredIPVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
