// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> The PortalConfigDelegationProperties. </summary>
    public partial class PortalConfigDelegationProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PortalConfigDelegationProperties"/>. </summary>
        public PortalConfigDelegationProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PortalConfigDelegationProperties"/>. </summary>
        /// <param name="delegateRegistration"> Enable or disable delegation for user registration. </param>
        /// <param name="delegateSubscription"> Enable or disable delegation for product subscriptions. </param>
        /// <param name="delegationUri"> A delegation endpoint URL. </param>
        /// <param name="validationKey"> A base64-encoded validation key to ensure requests originate from Azure API Management service. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PortalConfigDelegationProperties(bool? delegateRegistration, bool? delegateSubscription, Uri delegationUri, string validationKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DelegateRegistration = delegateRegistration;
            DelegateSubscription = delegateSubscription;
            DelegationUri = delegationUri;
            ValidationKey = validationKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Enable or disable delegation for user registration. </summary>
        [WirePath("delegateRegistration")]
        public bool? DelegateRegistration { get; set; }
        /// <summary> Enable or disable delegation for product subscriptions. </summary>
        [WirePath("delegateSubscription")]
        public bool? DelegateSubscription { get; set; }
        /// <summary> A delegation endpoint URL. </summary>
        [WirePath("delegationUrl")]
        public Uri DelegationUri { get; set; }
        /// <summary> A base64-encoded validation key to ensure requests originate from Azure API Management service. </summary>
        [WirePath("validationKey")]
        public string ValidationKey { get; set; }
    }
}
