// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ApiManagement.Models
{
    public partial class PortalConfigDelegationProperties : IUtf8JsonSerializable, IJsonModel<PortalConfigDelegationProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PortalConfigDelegationProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PortalConfigDelegationProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PortalConfigDelegationProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PortalConfigDelegationProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(DelegateRegistration))
            {
                writer.WritePropertyName("delegateRegistration"u8);
                writer.WriteBooleanValue(DelegateRegistration.Value);
            }
            if (Optional.IsDefined(DelegateSubscription))
            {
                writer.WritePropertyName("delegateSubscription"u8);
                writer.WriteBooleanValue(DelegateSubscription.Value);
            }
            if (Optional.IsDefined(DelegationUri))
            {
                writer.WritePropertyName("delegationUrl"u8);
                writer.WriteStringValue(DelegationUri.AbsoluteUri);
            }
            if (Optional.IsDefined(ValidationKey))
            {
                writer.WritePropertyName("validationKey"u8);
                writer.WriteStringValue(ValidationKey);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PortalConfigDelegationProperties IJsonModel<PortalConfigDelegationProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PortalConfigDelegationProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PortalConfigDelegationProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePortalConfigDelegationProperties(document.RootElement, options);
        }

        internal static PortalConfigDelegationProperties DeserializePortalConfigDelegationProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? delegateRegistration = default;
            bool? delegateSubscription = default;
            Uri delegationUri = default;
            string validationKey = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("delegateRegistration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    delegateRegistration = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("delegateSubscription"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    delegateSubscription = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("delegationUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    delegationUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("validationKey"u8))
                {
                    validationKey = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PortalConfigDelegationProperties(delegateRegistration, delegateSubscription, delegationUri, validationKey, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DelegateRegistration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  delegateRegistration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DelegateRegistration))
                {
                    builder.Append("  delegateRegistration: ");
                    var boolValue = DelegateRegistration.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DelegateSubscription), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  delegateSubscription: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DelegateSubscription))
                {
                    builder.Append("  delegateSubscription: ");
                    var boolValue = DelegateSubscription.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DelegationUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  delegationUrl: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DelegationUri))
                {
                    builder.Append("  delegationUrl: ");
                    builder.AppendLine($"'{DelegationUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ValidationKey), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  validationKey: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ValidationKey))
                {
                    builder.Append("  validationKey: ");
                    if (ValidationKey.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ValidationKey}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ValidationKey}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<PortalConfigDelegationProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PortalConfigDelegationProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(PortalConfigDelegationProperties)} does not support writing '{options.Format}' format.");
            }
        }

        PortalConfigDelegationProperties IPersistableModel<PortalConfigDelegationProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PortalConfigDelegationProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePortalConfigDelegationProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PortalConfigDelegationProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PortalConfigDelegationProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
