// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> The PolicyName. </summary>
    public readonly partial struct PolicyName : IEquatable<PolicyName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PolicyName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PolicyName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PolicyValue = "policy";

        /// <summary> policy. </summary>
        public static PolicyName Policy { get; } = new PolicyName(PolicyValue);
        /// <summary> Determines if two <see cref="PolicyName"/> values are the same. </summary>
        public static bool operator ==(PolicyName left, PolicyName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PolicyName"/> values are not the same. </summary>
        public static bool operator !=(PolicyName left, PolicyName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PolicyName"/>. </summary>
        public static implicit operator PolicyName(string value) => new PolicyName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PolicyName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PolicyName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
