// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> The NotificationName. </summary>
    public readonly partial struct NotificationName : IEquatable<NotificationName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NotificationName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NotificationName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RequestPublisherNotificationMessageValue = "RequestPublisherNotificationMessage";
        private const string PurchasePublisherNotificationMessageValue = "PurchasePublisherNotificationMessage";
        private const string NewApplicationNotificationMessageValue = "NewApplicationNotificationMessage";
        private const string BccValue = "BCC";
        private const string NewIssuePublisherNotificationMessageValue = "NewIssuePublisherNotificationMessage";
        private const string AccountClosedPublisherValue = "AccountClosedPublisher";
        private const string QuotaLimitApproachingPublisherNotificationMessageValue = "QuotaLimitApproachingPublisherNotificationMessage";

        /// <summary> The following email recipients and users will receive email notifications about subscription requests for API products requiring approval. </summary>
        public static NotificationName RequestPublisherNotificationMessage { get; } = new NotificationName(RequestPublisherNotificationMessageValue);
        /// <summary> The following email recipients and users will receive email notifications about new API product subscriptions. </summary>
        public static NotificationName PurchasePublisherNotificationMessage { get; } = new NotificationName(PurchasePublisherNotificationMessageValue);
        /// <summary> The following email recipients and users will receive email notifications when new applications are submitted to the application gallery. </summary>
        public static NotificationName NewApplicationNotificationMessage { get; } = new NotificationName(NewApplicationNotificationMessageValue);
        /// <summary> The following recipients will receive blind carbon copies of all emails sent to developers. </summary>
        public static NotificationName Bcc { get; } = new NotificationName(BccValue);
        /// <summary> The following email recipients and users will receive email notifications when a new issue or comment is submitted on the developer portal. </summary>
        public static NotificationName NewIssuePublisherNotificationMessage { get; } = new NotificationName(NewIssuePublisherNotificationMessageValue);
        /// <summary> The following email recipients and users will receive email notifications when developer closes his account. </summary>
        public static NotificationName AccountClosedPublisher { get; } = new NotificationName(AccountClosedPublisherValue);
        /// <summary> The following email recipients and users will receive email notifications when subscription usage gets close to usage quota. </summary>
        public static NotificationName QuotaLimitApproachingPublisherNotificationMessage { get; } = new NotificationName(QuotaLimitApproachingPublisherNotificationMessageValue);
        /// <summary> Determines if two <see cref="NotificationName"/> values are the same. </summary>
        public static bool operator ==(NotificationName left, NotificationName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NotificationName"/> values are not the same. </summary>
        public static bool operator !=(NotificationName left, NotificationName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NotificationName"/>. </summary>
        public static implicit operator NotificationName(string value) => new NotificationName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NotificationName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NotificationName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
