// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Status of legacy portal in the API Management service. </summary>
    public readonly partial struct LegacyPortalStatus : IEquatable<LegacyPortalStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LegacyPortalStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LegacyPortalStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Legacy Portal is enabled for the service. </summary>
        public static LegacyPortalStatus Enabled { get; } = new LegacyPortalStatus(EnabledValue);
        /// <summary> Legacy Portal is disabled for the service. </summary>
        public static LegacyPortalStatus Disabled { get; } = new LegacyPortalStatus(DisabledValue);
        /// <summary> Determines if two <see cref="LegacyPortalStatus"/> values are the same. </summary>
        public static bool operator ==(LegacyPortalStatus left, LegacyPortalStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LegacyPortalStatus"/> values are not the same. </summary>
        public static bool operator !=(LegacyPortalStatus left, LegacyPortalStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LegacyPortalStatus"/>. </summary>
        public static implicit operator LegacyPortalStatus(string value) => new LegacyPortalStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LegacyPortalStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LegacyPortalStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
