// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Status of the issue. </summary>
    public readonly partial struct IssueState : IEquatable<IssueState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IssueState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IssueState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProposedValue = "proposed";
        private const string OpenValue = "open";
        private const string RemovedValue = "removed";
        private const string ResolvedValue = "resolved";
        private const string ClosedValue = "closed";

        /// <summary> The issue is proposed. </summary>
        public static IssueState Proposed { get; } = new IssueState(ProposedValue);
        /// <summary> The issue is opened. </summary>
        public static IssueState Open { get; } = new IssueState(OpenValue);
        /// <summary> The issue was removed. </summary>
        public static IssueState Removed { get; } = new IssueState(RemovedValue);
        /// <summary> The issue is now resolved. </summary>
        public static IssueState Resolved { get; } = new IssueState(ResolvedValue);
        /// <summary> The issue was closed. </summary>
        public static IssueState Closed { get; } = new IssueState(ClosedValue);
        /// <summary> Determines if two <see cref="IssueState"/> values are the same. </summary>
        public static bool operator ==(IssueState left, IssueState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IssueState"/> values are not the same. </summary>
        public static bool operator !=(IssueState left, IssueState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IssueState"/>. </summary>
        public static implicit operator IssueState(string value) => new IssueState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IssueState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IssueState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
