// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Http message diagnostic settings. </summary>
    public partial class HttpMessageDiagnostic
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HttpMessageDiagnostic"/>. </summary>
        public HttpMessageDiagnostic()
        {
            Headers = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="HttpMessageDiagnostic"/>. </summary>
        /// <param name="headers"> Array of HTTP Headers to log. </param>
        /// <param name="body"> Body logging settings. </param>
        /// <param name="dataMasking"> Data masking settings. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HttpMessageDiagnostic(IList<string> headers, BodyDiagnosticSettings body, DataMasking dataMasking, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Headers = headers;
            Body = body;
            DataMasking = dataMasking;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Array of HTTP Headers to log. </summary>
        [WirePath("headers")]
        public IList<string> Headers { get; }
        /// <summary> Body logging settings. </summary>
        internal BodyDiagnosticSettings Body { get; set; }
        /// <summary> Number of request body bytes to log. </summary>
        [WirePath("body.bytes")]
        public int? BodyBytes
        {
            get => Body is null ? default : Body.Bytes;
            set
            {
                if (Body is null)
                    Body = new BodyDiagnosticSettings();
                Body.Bytes = value;
            }
        }

        /// <summary> Data masking settings. </summary>
        [WirePath("dataMasking")]
        public DataMasking DataMasking { get; set; }
    }
}
