// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Hostname type. </summary>
    public readonly partial struct HostnameType : IEquatable<HostnameType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HostnameType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HostnameType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProxyValue = "Proxy";
        private const string PortalValue = "Portal";
        private const string ManagementValue = "Management";
        private const string ScmValue = "Scm";
        private const string DeveloperPortalValue = "DeveloperPortal";
        private const string ConfigurationApiValue = "ConfigurationApi";

        /// <summary> Proxy. </summary>
        public static HostnameType Proxy { get; } = new HostnameType(ProxyValue);
        /// <summary> Portal. </summary>
        public static HostnameType Portal { get; } = new HostnameType(PortalValue);
        /// <summary> Management. </summary>
        public static HostnameType Management { get; } = new HostnameType(ManagementValue);
        /// <summary> Scm. </summary>
        public static HostnameType Scm { get; } = new HostnameType(ScmValue);
        /// <summary> DeveloperPortal. </summary>
        public static HostnameType DeveloperPortal { get; } = new HostnameType(DeveloperPortalValue);
        /// <summary> ConfigurationApi. </summary>
        public static HostnameType ConfigurationApi { get; } = new HostnameType(ConfigurationApiValue);
        /// <summary> Determines if two <see cref="HostnameType"/> values are the same. </summary>
        public static bool operator ==(HostnameType left, HostnameType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HostnameType"/> values are not the same. </summary>
        public static bool operator !=(HostnameType left, HostnameType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HostnameType"/>. </summary>
        public static implicit operator HostnameType(string value) => new HostnameType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HostnameType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HostnameType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
