// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Long Running Git Operation Results. </summary>
    public partial class GitOperationResultContractData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GitOperationResultContractData"/>. </summary>
        public GitOperationResultContractData()
        {
            ActionLog = new ChangeTrackingList<OperationResultLogItemContract>();
        }

        /// <summary> Initializes a new instance of <see cref="GitOperationResultContractData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="operationResultIdentifier"> Operation result identifier. </param>
        /// <param name="status"> Status of an async operation. </param>
        /// <param name="startedOn">
        /// Start time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </param>
        /// <param name="updatedOn">
        /// Last update time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </param>
        /// <param name="resultInfo"> Optional result info. </param>
        /// <param name="error"> Error Body Contract. </param>
        /// <param name="actionLog"> This property if only provided as part of the TenantConfiguration_Validate operation. It contains the log the entities which will be updated/created/deleted as part of the TenantConfiguration_Deploy operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GitOperationResultContractData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string operationResultIdentifier, AsyncOperationStatus? status, DateTimeOffset? startedOn, DateTimeOffset? updatedOn, string resultInfo, ErrorResponseBody error, IReadOnlyList<OperationResultLogItemContract> actionLog, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            OperationResultIdentifier = operationResultIdentifier;
            Status = status;
            StartedOn = startedOn;
            UpdatedOn = updatedOn;
            ResultInfo = resultInfo;
            Error = error;
            ActionLog = actionLog;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Operation result identifier. </summary>
        [WirePath("properties.id")]
        public string OperationResultIdentifier { get; set; }
        /// <summary> Status of an async operation. </summary>
        [WirePath("properties.status")]
        public AsyncOperationStatus? Status { get; set; }
        /// <summary>
        /// Start time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </summary>
        [WirePath("properties.started")]
        public DateTimeOffset? StartedOn { get; set; }
        /// <summary>
        /// Last update time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </summary>
        [WirePath("properties.updated")]
        public DateTimeOffset? UpdatedOn { get; set; }
        /// <summary> Optional result info. </summary>
        [WirePath("properties.resultInfo")]
        public string ResultInfo { get; set; }
        /// <summary> Error Body Contract. </summary>
        [WirePath("properties.error")]
        public ErrorResponseBody Error { get; set; }
        /// <summary> This property if only provided as part of the TenantConfiguration_Validate operation. It contains the log the entities which will be updated/created/deleted as part of the TenantConfiguration_Deploy operation. </summary>
        [WirePath("properties.actionLog")]
        public IReadOnlyList<OperationResultLogItemContract> ActionLog { get; }
    }
}
