// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ApiManagement.Models
{
    internal static partial class GatewayRegenerateKeyTypeExtensions
    {
        public static string ToSerialString(this GatewayRegenerateKeyType value) => value switch
        {
            GatewayRegenerateKeyType.Primary => "primary",
            GatewayRegenerateKeyType.Secondary => "secondary",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown GatewayRegenerateKeyType value.")
        };

        public static GatewayRegenerateKeyType ToGatewayRegenerateKeyType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "primary")) return GatewayRegenerateKeyType.Primary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "secondary")) return GatewayRegenerateKeyType.Secondary;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown GatewayRegenerateKeyType value.");
        }
    }
}
