// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Purpose of debug credential. </summary>
    public readonly partial struct GatewayListDebugCredentialsContractPurpose : IEquatable<GatewayListDebugCredentialsContractPurpose>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GatewayListDebugCredentialsContractPurpose"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GatewayListDebugCredentialsContractPurpose(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TracingValue = "tracing";

        /// <summary> The tracing purpose. </summary>
        public static GatewayListDebugCredentialsContractPurpose Tracing { get; } = new GatewayListDebugCredentialsContractPurpose(TracingValue);
        /// <summary> Determines if two <see cref="GatewayListDebugCredentialsContractPurpose"/> values are the same. </summary>
        public static bool operator ==(GatewayListDebugCredentialsContractPurpose left, GatewayListDebugCredentialsContractPurpose right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GatewayListDebugCredentialsContractPurpose"/> values are not the same. </summary>
        public static bool operator !=(GatewayListDebugCredentialsContractPurpose left, GatewayListDebugCredentialsContractPurpose right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GatewayListDebugCredentialsContractPurpose"/>. </summary>
        public static implicit operator GatewayListDebugCredentialsContractPurpose(string value) => new GatewayListDebugCredentialsContractPurpose(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GatewayListDebugCredentialsContractPurpose other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GatewayListDebugCredentialsContractPurpose other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
