// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Gateway authentication keys. </summary>
    public partial class GatewayKeysContract
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GatewayKeysContract"/>. </summary>
        internal GatewayKeysContract()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GatewayKeysContract"/>. </summary>
        /// <param name="primary"> Primary gateway key. </param>
        /// <param name="secondary"> Secondary gateway key. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GatewayKeysContract(string primary, string secondary, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Primary = primary;
            Secondary = secondary;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Primary gateway key. </summary>
        [WirePath("primary")]
        public string Primary { get; }
        /// <summary> Secondary gateway key. </summary>
        [WirePath("secondary")]
        public string Secondary { get; }
    }
}
