// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Error Body contract. </summary>
    public partial class ErrorResponseBody
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ErrorResponseBody"/>. </summary>
        public ErrorResponseBody()
        {
            Details = new ChangeTrackingList<ErrorFieldContract>();
        }

        /// <summary> Initializes a new instance of <see cref="ErrorResponseBody"/>. </summary>
        /// <param name="code"> Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response. </param>
        /// <param name="message"> Human-readable representation of the error. </param>
        /// <param name="details"> The list of invalid fields send in request, in case of validation error. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ErrorResponseBody(string code, string message, IList<ErrorFieldContract> details, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Code = code;
            Message = message;
            Details = details;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response. </summary>
        [WirePath("code")]
        public string Code { get; set; }
        /// <summary> Human-readable representation of the error. </summary>
        [WirePath("message")]
        public string Message { get; set; }
        /// <summary> The list of invalid fields send in request, in case of validation error. </summary>
        [WirePath("details")]
        public IList<ErrorFieldContract> Details { get; }
    }
}
