// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Error Field contract. </summary>
    public partial class ErrorFieldContract
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ErrorFieldContract"/>. </summary>
        public ErrorFieldContract()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ErrorFieldContract"/>. </summary>
        /// <param name="code"> Property level error code. </param>
        /// <param name="message"> Human-readable representation of property-level error. </param>
        /// <param name="target"> Property name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ErrorFieldContract(string code, string message, string target, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Code = code;
            Message = message;
            Target = target;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Property level error code. </summary>
        [WirePath("code")]
        public string Code { get; set; }
        /// <summary> Human-readable representation of property-level error. </summary>
        [WirePath("message")]
        public string Message { get; set; }
        /// <summary> Property name. </summary>
        [WirePath("target")]
        public string Target { get; set; }
    }
}
