// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Status of developer portal in this API Management service. </summary>
    public readonly partial struct DeveloperPortalStatus : IEquatable<DeveloperPortalStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeveloperPortalStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeveloperPortalStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Developer Portal is enabled for the service. </summary>
        public static DeveloperPortalStatus Enabled { get; } = new DeveloperPortalStatus(EnabledValue);
        /// <summary> Developer Portal is disabled for the service. </summary>
        public static DeveloperPortalStatus Disabled { get; } = new DeveloperPortalStatus(DisabledValue);
        /// <summary> Determines if two <see cref="DeveloperPortalStatus"/> values are the same. </summary>
        public static bool operator ==(DeveloperPortalStatus left, DeveloperPortalStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeveloperPortalStatus"/> values are not the same. </summary>
        public static bool operator !=(DeveloperPortalStatus left, DeveloperPortalStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeveloperPortalStatus"/>. </summary>
        public static implicit operator DeveloperPortalStatus(string value) => new DeveloperPortalStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeveloperPortalStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeveloperPortalStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
