// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Data masking mode. </summary>
    public readonly partial struct DataMaskingMode : IEquatable<DataMaskingMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataMaskingMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataMaskingMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MaskValue = "Mask";
        private const string HideValue = "Hide";

        /// <summary> Mask the value of an entity. </summary>
        public static DataMaskingMode Mask { get; } = new DataMaskingMode(MaskValue);
        /// <summary> Hide the presence of an entity. </summary>
        public static DataMaskingMode Hide { get; } = new DataMaskingMode(HideValue);
        /// <summary> Determines if two <see cref="DataMaskingMode"/> values are the same. </summary>
        public static bool operator ==(DataMaskingMode left, DataMaskingMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataMaskingMode"/> values are not the same. </summary>
        public static bool operator !=(DataMaskingMode left, DataMaskingMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataMaskingMode"/>. </summary>
        public static implicit operator DataMaskingMode(string value) => new DataMaskingMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataMaskingMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataMaskingMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
