// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> The DataMaskingEntity. </summary>
    public partial class DataMaskingEntity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataMaskingEntity"/>. </summary>
        public DataMaskingEntity()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataMaskingEntity"/>. </summary>
        /// <param name="value"> The name of an entity to mask (e.g. a name of a header or a query parameter). </param>
        /// <param name="mode"> Data masking mode. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataMaskingEntity(string value, DataMaskingMode? mode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            Mode = mode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of an entity to mask (e.g. a name of a header or a query parameter). </summary>
        [WirePath("value")]
        public string Value { get; set; }
        /// <summary> Data masking mode. </summary>
        [WirePath("mode")]
        public DataMaskingMode? Mode { get; set; }
    }
}
