// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Details about connectivity to a resource. </summary>
    public partial class ConnectivityStatusContract
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectivityStatusContract"/>. </summary>
        /// <param name="name"> The hostname of the resource which the service depends on. This can be the database, storage or any other azure resource on which the service depends upon. </param>
        /// <param name="status"> Resource Connectivity Status Type identifier. </param>
        /// <param name="lastUpdatedOn">
        /// The date when the resource connectivity status was last updated. This status should be updated every 15 minutes. If this status has not been updated, then it means that the service has lost network connectivity to the resource, from inside the Virtual Network.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </param>
        /// <param name="lastStatusChangedOn">
        /// The date when the resource connectivity status last Changed from success to failure or vice-versa. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </param>
        /// <param name="resourceType"> Resource Type. </param>
        /// <param name="isOptional"> Whether this is optional. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="resourceType"/> is null. </exception>
        internal ConnectivityStatusContract(string name, ConnectivityStatusType status, DateTimeOffset lastUpdatedOn, DateTimeOffset lastStatusChangedOn, string resourceType, bool isOptional)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(resourceType, nameof(resourceType));

            Name = name;
            Status = status;
            LastUpdatedOn = lastUpdatedOn;
            LastStatusChangedOn = lastStatusChangedOn;
            ResourceType = resourceType;
            IsOptional = isOptional;
        }

        /// <summary> Initializes a new instance of <see cref="ConnectivityStatusContract"/>. </summary>
        /// <param name="name"> The hostname of the resource which the service depends on. This can be the database, storage or any other azure resource on which the service depends upon. </param>
        /// <param name="status"> Resource Connectivity Status Type identifier. </param>
        /// <param name="error"> Error details of the connectivity to the resource. </param>
        /// <param name="lastUpdatedOn">
        /// The date when the resource connectivity status was last updated. This status should be updated every 15 minutes. If this status has not been updated, then it means that the service has lost network connectivity to the resource, from inside the Virtual Network.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </param>
        /// <param name="lastStatusChangedOn">
        /// The date when the resource connectivity status last Changed from success to failure or vice-versa. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </param>
        /// <param name="resourceType"> Resource Type. </param>
        /// <param name="isOptional"> Whether this is optional. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectivityStatusContract(string name, ConnectivityStatusType status, string error, DateTimeOffset lastUpdatedOn, DateTimeOffset lastStatusChangedOn, string resourceType, bool isOptional, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Status = status;
            Error = error;
            LastUpdatedOn = lastUpdatedOn;
            LastStatusChangedOn = lastStatusChangedOn;
            ResourceType = resourceType;
            IsOptional = isOptional;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ConnectivityStatusContract"/> for deserialization. </summary>
        internal ConnectivityStatusContract()
        {
        }

        /// <summary> The hostname of the resource which the service depends on. This can be the database, storage or any other azure resource on which the service depends upon. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> Resource Connectivity Status Type identifier. </summary>
        [WirePath("status")]
        public ConnectivityStatusType Status { get; }
        /// <summary> Error details of the connectivity to the resource. </summary>
        [WirePath("error")]
        public string Error { get; }
        /// <summary>
        /// The date when the resource connectivity status was last updated. This status should be updated every 15 minutes. If this status has not been updated, then it means that the service has lost network connectivity to the resource, from inside the Virtual Network.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </summary>
        [WirePath("lastUpdated")]
        public DateTimeOffset LastUpdatedOn { get; }
        /// <summary>
        /// The date when the resource connectivity status last Changed from success to failure or vice-versa. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        ///
        /// </summary>
        [WirePath("lastStatusChange")]
        public DateTimeOffset LastStatusChangedOn { get; }
        /// <summary> Resource Type. </summary>
        [WirePath("resourceType")]
        public string ResourceType { get; }
        /// <summary> Whether this is optional. </summary>
        [WirePath("isOptional")]
        public bool IsOptional { get; }
    }
}
