// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Information on the connectivity status. </summary>
    public partial class ConnectivityCheckResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectivityCheckResult"/>. </summary>
        internal ConnectivityCheckResult()
        {
            Hops = new ChangeTrackingList<ConnectivityHop>();
        }

        /// <summary> Initializes a new instance of <see cref="ConnectivityCheckResult"/>. </summary>
        /// <param name="hops"> List of hops between the source and the destination. </param>
        /// <param name="connectionStatus"> The connection status. </param>
        /// <param name="avgLatencyInMs"> Average latency in milliseconds. </param>
        /// <param name="minLatencyInMs"> Minimum latency in milliseconds. </param>
        /// <param name="maxLatencyInMs"> Maximum latency in milliseconds. </param>
        /// <param name="probesSent"> Total number of probes sent. </param>
        /// <param name="probesFailed"> Number of failed probes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectivityCheckResult(IReadOnlyList<ConnectivityHop> hops, ConnectionStatus? connectionStatus, long? avgLatencyInMs, long? minLatencyInMs, long? maxLatencyInMs, long? probesSent, long? probesFailed, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Hops = hops;
            ConnectionStatus = connectionStatus;
            AvgLatencyInMs = avgLatencyInMs;
            MinLatencyInMs = minLatencyInMs;
            MaxLatencyInMs = maxLatencyInMs;
            ProbesSent = probesSent;
            ProbesFailed = probesFailed;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of hops between the source and the destination. </summary>
        [WirePath("hops")]
        public IReadOnlyList<ConnectivityHop> Hops { get; }
        /// <summary> The connection status. </summary>
        [WirePath("connectionStatus")]
        public ConnectionStatus? ConnectionStatus { get; }
        /// <summary> Average latency in milliseconds. </summary>
        [WirePath("avgLatencyInMs")]
        public long? AvgLatencyInMs { get; }
        /// <summary> Minimum latency in milliseconds. </summary>
        [WirePath("minLatencyInMs")]
        public long? MinLatencyInMs { get; }
        /// <summary> Maximum latency in milliseconds. </summary>
        [WirePath("maxLatencyInMs")]
        public long? MaxLatencyInMs { get; }
        /// <summary> Total number of probes sent. </summary>
        [WirePath("probesSent")]
        public long? ProbesSent { get; }
        /// <summary> Number of failed probes. </summary>
        [WirePath("probesFailed")]
        public long? ProbesFailed { get; }
    }
}
