// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Configuration for HTTP or HTTPS requests. </summary>
    public partial class ConnectivityCheckRequestHttpConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectivityCheckRequestHttpConfiguration"/>. </summary>
        public ConnectivityCheckRequestHttpConfiguration()
        {
            ValidStatusCodes = new ChangeTrackingList<long>();
            Headers = new ChangeTrackingList<HttpHeaderConfiguration>();
        }

        /// <summary> Initializes a new instance of <see cref="ConnectivityCheckRequestHttpConfiguration"/>. </summary>
        /// <param name="method"> The HTTP method to be used. </param>
        /// <param name="validStatusCodes"> List of HTTP status codes considered valid for the request response. </param>
        /// <param name="headers"> List of headers to be included in the request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectivityCheckRequestHttpConfiguration(HttpMethodConfiguration? method, IList<long> validStatusCodes, IList<HttpHeaderConfiguration> headers, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Method = method;
            ValidStatusCodes = validStatusCodes;
            Headers = headers;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The HTTP method to be used. </summary>
        [WirePath("method")]
        public HttpMethodConfiguration? Method { get; set; }
        /// <summary> List of HTTP status codes considered valid for the request response. </summary>
        [WirePath("validStatusCodes")]
        public IList<long> ValidStatusCodes { get; }
        /// <summary> List of headers to be included in the request. </summary>
        [WirePath("headers")]
        public IList<HttpHeaderConfiguration> Headers { get; }
    }
}
