// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Determines the type of confirmation e-mail that will be sent to the newly created user. </summary>
    public readonly partial struct ConfirmationEmailType : IEquatable<ConfirmationEmailType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConfirmationEmailType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConfirmationEmailType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SignUpValue = "signup";
        private const string InviteValue = "invite";

        /// <summary> Send an e-mail to the user confirming they have successfully signed up. </summary>
        public static ConfirmationEmailType SignUp { get; } = new ConfirmationEmailType(SignUpValue);
        /// <summary> Send an e-mail inviting the user to sign-up and complete registration. </summary>
        public static ConfirmationEmailType Invite { get; } = new ConfirmationEmailType(InviteValue);
        /// <summary> Determines if two <see cref="ConfirmationEmailType"/> values are the same. </summary>
        public static bool operator ==(ConfirmationEmailType left, ConfirmationEmailType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConfirmationEmailType"/> values are not the same. </summary>
        public static bool operator !=(ConfirmationEmailType left, ConfirmationEmailType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConfirmationEmailType"/>. </summary>
        public static implicit operator ConfirmationEmailType(string value) => new ConfirmationEmailType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConfirmationEmailType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConfirmationEmailType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
