// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Rule configuration to trip the backend. </summary>
    public partial class CircuitBreakerRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CircuitBreakerRule"/>. </summary>
        public CircuitBreakerRule()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CircuitBreakerRule"/>. </summary>
        /// <param name="name"> The rule name. </param>
        /// <param name="failureCondition"> The conditions for tripping the circuit breaker. </param>
        /// <param name="tripDuration"> The duration for which the circuit will be tripped. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CircuitBreakerRule(string name, CircuitBreakerFailureCondition failureCondition, TimeSpan? tripDuration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            FailureCondition = failureCondition;
            TripDuration = tripDuration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The rule name. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> The conditions for tripping the circuit breaker. </summary>
        [WirePath("failureCondition")]
        public CircuitBreakerFailureCondition FailureCondition { get; set; }
        /// <summary> The duration for which the circuit will be tripped. </summary>
        [WirePath("tripDuration")]
        public TimeSpan? TripDuration { get; set; }
    }
}
