// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> The trip conditions of the circuit breaker. </summary>
    public partial class CircuitBreakerFailureCondition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CircuitBreakerFailureCondition"/>. </summary>
        public CircuitBreakerFailureCondition()
        {
            StatusCodeRanges = new ChangeTrackingList<FailureStatusCodeRange>();
            ErrorReasons = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="CircuitBreakerFailureCondition"/>. </summary>
        /// <param name="count"> The threshold for opening the circuit. </param>
        /// <param name="percentage"> The threshold for opening the circuit. </param>
        /// <param name="interval"> The interval during which the failures are counted. </param>
        /// <param name="statusCodeRanges"> The status code ranges which are considered as failure. </param>
        /// <param name="errorReasons"> The error reasons which are considered as failure. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CircuitBreakerFailureCondition(long? count, long? percentage, TimeSpan? interval, IList<FailureStatusCodeRange> statusCodeRanges, IList<string> errorReasons, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Count = count;
            Percentage = percentage;
            Interval = interval;
            StatusCodeRanges = statusCodeRanges;
            ErrorReasons = errorReasons;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The threshold for opening the circuit. </summary>
        [WirePath("count")]
        public long? Count { get; set; }
        /// <summary> The threshold for opening the circuit. </summary>
        [WirePath("percentage")]
        public long? Percentage { get; set; }
        /// <summary> The interval during which the failures are counted. </summary>
        [WirePath("interval")]
        public TimeSpan? Interval { get; set; }
        /// <summary> The status code ranges which are considered as failure. </summary>
        [WirePath("statusCodeRanges")]
        public IList<FailureStatusCodeRange> StatusCodeRanges { get; }
        /// <summary> The error reasons which are considered as failure. </summary>
        [WirePath("errorReasons")]
        public IList<string> ErrorReasons { get; }
    }
}
