// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> SSL certificate information. </summary>
    public partial class CertificateInformation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CertificateInformation"/>. </summary>
        /// <param name="expireOn"> Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard. </param>
        /// <param name="thumbprint"> Thumbprint of the certificate. </param>
        /// <param name="subject"> Subject of the certificate. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="thumbprint"/> or <paramref name="subject"/> is null. </exception>
        public CertificateInformation(DateTimeOffset expireOn, string thumbprint, string subject)
        {
            Argument.AssertNotNull(thumbprint, nameof(thumbprint));
            Argument.AssertNotNull(subject, nameof(subject));

            ExpireOn = expireOn;
            Thumbprint = thumbprint;
            Subject = subject;
        }

        /// <summary> Initializes a new instance of <see cref="CertificateInformation"/>. </summary>
        /// <param name="expireOn"> Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard. </param>
        /// <param name="thumbprint"> Thumbprint of the certificate. </param>
        /// <param name="subject"> Subject of the certificate. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CertificateInformation(DateTimeOffset expireOn, string thumbprint, string subject, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExpireOn = expireOn;
            Thumbprint = thumbprint;
            Subject = subject;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CertificateInformation"/> for deserialization. </summary>
        internal CertificateInformation()
        {
        }

        /// <summary> Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard. </summary>
        [WirePath("expiry")]
        public DateTimeOffset ExpireOn { get; set; }
        /// <summary> Thumbprint of the certificate. </summary>
        [WirePath("thumbprint")]
        public string Thumbprint { get; set; }
        /// <summary> Subject of the certificate. </summary>
        [WirePath("subject")]
        public string Subject { get; set; }
    }
}
