// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only Root and CertificateAuthority are valid locations. </summary>
    public readonly partial struct CertificateConfigurationStoreName : IEquatable<CertificateConfigurationStoreName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CertificateConfigurationStoreName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CertificateConfigurationStoreName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CertificateAuthorityValue = "CertificateAuthority";
        private const string RootValue = "Root";

        /// <summary> CertificateAuthority. </summary>
        public static CertificateConfigurationStoreName CertificateAuthority { get; } = new CertificateConfigurationStoreName(CertificateAuthorityValue);
        /// <summary> Root. </summary>
        public static CertificateConfigurationStoreName Root { get; } = new CertificateConfigurationStoreName(RootValue);
        /// <summary> Determines if two <see cref="CertificateConfigurationStoreName"/> values are the same. </summary>
        public static bool operator ==(CertificateConfigurationStoreName left, CertificateConfigurationStoreName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CertificateConfigurationStoreName"/> values are not the same. </summary>
        public static bool operator !=(CertificateConfigurationStoreName left, CertificateConfigurationStoreName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CertificateConfigurationStoreName"/>. </summary>
        public static implicit operator CertificateConfigurationStoreName(string value) => new CertificateConfigurationStoreName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CertificateConfigurationStoreName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CertificateConfigurationStoreName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
