// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> The BearerTokenSendingMethod. </summary>
    public readonly partial struct BearerTokenSendingMethod : IEquatable<BearerTokenSendingMethod>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BearerTokenSendingMethod"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BearerTokenSendingMethod(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AuthorizationHeaderValue = "authorizationHeader";
        private const string QueryValue = "query";

        /// <summary> authorizationHeader. </summary>
        public static BearerTokenSendingMethod AuthorizationHeader { get; } = new BearerTokenSendingMethod(AuthorizationHeaderValue);
        /// <summary> query. </summary>
        public static BearerTokenSendingMethod Query { get; } = new BearerTokenSendingMethod(QueryValue);
        /// <summary> Determines if two <see cref="BearerTokenSendingMethod"/> values are the same. </summary>
        public static bool operator ==(BearerTokenSendingMethod left, BearerTokenSendingMethod right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BearerTokenSendingMethod"/> values are not the same. </summary>
        public static bool operator !=(BearerTokenSendingMethod left, BearerTokenSendingMethod right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BearerTokenSendingMethod"/>. </summary>
        public static implicit operator BearerTokenSendingMethod(string value) => new BearerTokenSendingMethod(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BearerTokenSendingMethod other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BearerTokenSendingMethod other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
