// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Properties of the Service Fabric Type Backend. </summary>
    public partial class BackendServiceFabricClusterProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackendServiceFabricClusterProperties"/>. </summary>
        /// <param name="managementEndpoints"> The cluster management endpoint. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="managementEndpoints"/> is null. </exception>
        public BackendServiceFabricClusterProperties(IEnumerable<string> managementEndpoints)
        {
            Argument.AssertNotNull(managementEndpoints, nameof(managementEndpoints));

            ManagementEndpoints = managementEndpoints.ToList();
            ServerCertificateThumbprints = new ChangeTrackingList<string>();
            ServerX509Names = new ChangeTrackingList<X509CertificateName>();
        }

        /// <summary> Initializes a new instance of <see cref="BackendServiceFabricClusterProperties"/>. </summary>
        /// <param name="clientCertificateId"> The client certificate id for the management endpoint. </param>
        /// <param name="clientCertificatethumbprint"> The client certificate thumbprint for the management endpoint. Will be ignored if certificatesIds are provided. </param>
        /// <param name="maxPartitionResolutionRetries"> Maximum number of retries while attempting resolve the partition. </param>
        /// <param name="managementEndpoints"> The cluster management endpoint. </param>
        /// <param name="serverCertificateThumbprints"> Thumbprints of certificates cluster management service uses for tls communication. </param>
        /// <param name="serverX509Names"> Server X509 Certificate Names Collection. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackendServiceFabricClusterProperties(string clientCertificateId, string clientCertificatethumbprint, int? maxPartitionResolutionRetries, IList<string> managementEndpoints, IList<string> serverCertificateThumbprints, IList<X509CertificateName> serverX509Names, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClientCertificateId = clientCertificateId;
            ClientCertificatethumbprint = clientCertificatethumbprint;
            MaxPartitionResolutionRetries = maxPartitionResolutionRetries;
            ManagementEndpoints = managementEndpoints;
            ServerCertificateThumbprints = serverCertificateThumbprints;
            ServerX509Names = serverX509Names;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BackendServiceFabricClusterProperties"/> for deserialization. </summary>
        internal BackendServiceFabricClusterProperties()
        {
        }

        /// <summary> The client certificate id for the management endpoint. </summary>
        [WirePath("clientCertificateId")]
        public string ClientCertificateId { get; set; }
        /// <summary> The client certificate thumbprint for the management endpoint. Will be ignored if certificatesIds are provided. </summary>
        [WirePath("clientCertificatethumbprint")]
        public string ClientCertificatethumbprint { get; set; }
        /// <summary> Maximum number of retries while attempting resolve the partition. </summary>
        [WirePath("maxPartitionResolutionRetries")]
        public int? MaxPartitionResolutionRetries { get; set; }
        /// <summary> The cluster management endpoint. </summary>
        [WirePath("managementEndpoints")]
        public IList<string> ManagementEndpoints { get; }
        /// <summary> Thumbprints of certificates cluster management service uses for tls communication. </summary>
        [WirePath("serverCertificateThumbprints")]
        public IList<string> ServerCertificateThumbprints { get; }
        /// <summary> Server X509 Certificate Names Collection. </summary>
        [WirePath("serverX509Names")]
        public IList<X509CertificateName> ServerX509Names { get; }
    }
}
