// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Backend communication protocol. </summary>
    public readonly partial struct BackendProtocol : IEquatable<BackendProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackendProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackendProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HttpValue = "http";
        private const string SoapValue = "soap";

        /// <summary> The Backend is a RESTful service. </summary>
        public static BackendProtocol Http { get; } = new BackendProtocol(HttpValue);
        /// <summary> The Backend is a SOAP service. </summary>
        public static BackendProtocol Soap { get; } = new BackendProtocol(SoapValue);
        /// <summary> Determines if two <see cref="BackendProtocol"/> values are the same. </summary>
        public static bool operator ==(BackendProtocol left, BackendProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackendProtocol"/> values are not the same. </summary>
        public static bool operator !=(BackendProtocol left, BackendProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackendProtocol"/>. </summary>
        public static implicit operator BackendProtocol(string value) => new BackendProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackendProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackendProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
