// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Properties specific to the Backend Type. </summary>
    internal partial class BackendProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackendProperties"/>. </summary>
        public BackendProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackendProperties"/>. </summary>
        /// <param name="serviceFabricCluster"> Backend Service Fabric Cluster Properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackendProperties(BackendServiceFabricClusterProperties serviceFabricCluster, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ServiceFabricCluster = serviceFabricCluster;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Backend Service Fabric Cluster Properties. </summary>
        [WirePath("serviceFabricCluster")]
        public BackendServiceFabricClusterProperties ServiceFabricCluster { get; set; }
    }
}
