// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> OAuth2 settings details. </summary>
    public partial class AuthorizationProviderOAuth2Settings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AuthorizationProviderOAuth2Settings"/>. </summary>
        public AuthorizationProviderOAuth2Settings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AuthorizationProviderOAuth2Settings"/>. </summary>
        /// <param name="redirectUri"> Redirect URL to be set in the OAuth application. </param>
        /// <param name="grantTypes"> OAuth2 settings. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AuthorizationProviderOAuth2Settings(Uri redirectUri, AuthorizationProviderOAuth2GrantTypes grantTypes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RedirectUri = redirectUri;
            GrantTypes = grantTypes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Redirect URL to be set in the OAuth application. </summary>
        [WirePath("redirectUrl")]
        public Uri RedirectUri { get; set; }
        /// <summary> OAuth2 settings. </summary>
        [WirePath("grantTypes")]
        public AuthorizationProviderOAuth2GrantTypes GrantTypes { get; set; }
    }
}
