// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ApiManagement.Models
{
    internal static partial class AuthorizationMethodExtensions
    {
        public static string ToSerialString(this AuthorizationMethod value) => value switch
        {
            AuthorizationMethod.Head => "HEAD",
            AuthorizationMethod.Options => "OPTIONS",
            AuthorizationMethod.Trace => "TRACE",
            AuthorizationMethod.Get => "GET",
            AuthorizationMethod.Post => "POST",
            AuthorizationMethod.Put => "PUT",
            AuthorizationMethod.Patch => "PATCH",
            AuthorizationMethod.Delete => "DELETE",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AuthorizationMethod value.")
        };

        public static AuthorizationMethod ToAuthorizationMethod(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "HEAD")) return AuthorizationMethod.Head;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "OPTIONS")) return AuthorizationMethod.Options;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "TRACE")) return AuthorizationMethod.Trace;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "GET")) return AuthorizationMethod.Get;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "POST")) return AuthorizationMethod.Post;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "PUT")) return AuthorizationMethod.Put;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "PATCH")) return AuthorizationMethod.Patch;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DELETE")) return AuthorizationMethod.Delete;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AuthorizationMethod value.");
        }
    }
}
