// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ApiManagement.Models
{
    public partial class AuthorizationConfirmConsentCodeContent : IUtf8JsonSerializable, IJsonModel<AuthorizationConfirmConsentCodeContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AuthorizationConfirmConsentCodeContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AuthorizationConfirmConsentCodeContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AuthorizationConfirmConsentCodeContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AuthorizationConfirmConsentCodeContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ConsentCode))
            {
                writer.WritePropertyName("consentCode"u8);
                writer.WriteStringValue(ConsentCode);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AuthorizationConfirmConsentCodeContent IJsonModel<AuthorizationConfirmConsentCodeContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AuthorizationConfirmConsentCodeContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AuthorizationConfirmConsentCodeContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAuthorizationConfirmConsentCodeContent(document.RootElement, options);
        }

        internal static AuthorizationConfirmConsentCodeContent DeserializeAuthorizationConfirmConsentCodeContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string consentCode = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("consentCode"u8))
                {
                    consentCode = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AuthorizationConfirmConsentCodeContent(consentCode, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AuthorizationConfirmConsentCodeContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AuthorizationConfirmConsentCodeContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AuthorizationConfirmConsentCodeContent)} does not support writing '{options.Format}' format.");
            }
        }

        AuthorizationConfirmConsentCodeContent IPersistableModel<AuthorizationConfirmConsentCodeContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AuthorizationConfirmConsentCodeContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAuthorizationConfirmConsentCodeContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AuthorizationConfirmConsentCodeContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AuthorizationConfirmConsentCodeContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
