// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ApiManagement.Models
{
    internal static partial class AsyncOperationStatusExtensions
    {
        public static string ToSerialString(this AsyncOperationStatus value) => value switch
        {
            AsyncOperationStatus.Started => "Started",
            AsyncOperationStatus.InProgress => "InProgress",
            AsyncOperationStatus.Succeeded => "Succeeded",
            AsyncOperationStatus.Failed => "Failed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AsyncOperationStatus value.")
        };

        public static AsyncOperationStatus ToAsyncOperationStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Started")) return AsyncOperationStatus.Started;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "InProgress")) return AsyncOperationStatus.InProgress;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Succeeded")) return AsyncOperationStatus.Succeeded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return AsyncOperationStatus.Failed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AsyncOperationStatus value.");
        }
    }
}
