// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Provisioning state. </summary>
    public readonly partial struct AssociationEntityProvisioningState : IEquatable<AssociationEntityProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AssociationEntityProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AssociationEntityProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatedValue = "created";

        /// <summary> created. </summary>
        public static AssociationEntityProvisioningState Created { get; } = new AssociationEntityProvisioningState(CreatedValue);
        /// <summary> Determines if two <see cref="AssociationEntityProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AssociationEntityProvisioningState left, AssociationEntityProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AssociationEntityProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AssociationEntityProvisioningState left, AssociationEntityProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AssociationEntityProvisioningState"/>. </summary>
        public static implicit operator AssociationEntityProvisioningState(string value) => new AssociationEntityProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AssociationEntityProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AssociationEntityProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
