// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> The AppType. </summary>
    public readonly partial struct AppType : IEquatable<AppType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PortalValue = "portal";
        private const string DeveloperPortalValue = "developerPortal";

        /// <summary> User create request was sent by legacy developer portal. </summary>
        public static AppType Portal { get; } = new AppType(PortalValue);
        /// <summary> User create request was sent by new developer portal. </summary>
        public static AppType DeveloperPortal { get; } = new AppType(DeveloperPortalValue);
        /// <summary> Determines if two <see cref="AppType"/> values are the same. </summary>
        public static bool operator ==(AppType left, AppType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppType"/> values are not the same. </summary>
        public static bool operator !=(AppType left, AppType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppType"/>. </summary>
        public static implicit operator AppType(string value) => new AppType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
