// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Type of API. </summary>
    public readonly partial struct ApiType : IEquatable<ApiType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApiType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApiType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HttpValue = "http";
        private const string SoapValue = "soap";
        private const string WebSocketValue = "websocket";
        private const string GraphQLValue = "graphql";
        private const string OdataValue = "odata";

        /// <summary> http. </summary>
        public static ApiType Http { get; } = new ApiType(HttpValue);
        /// <summary> soap. </summary>
        public static ApiType Soap { get; } = new ApiType(SoapValue);
        /// <summary> websocket. </summary>
        public static ApiType WebSocket { get; } = new ApiType(WebSocketValue);
        /// <summary> graphql. </summary>
        public static ApiType GraphQL { get; } = new ApiType(GraphQLValue);
        /// <summary> odata. </summary>
        public static ApiType Odata { get; } = new ApiType(OdataValue);
        /// <summary> Determines if two <see cref="ApiType"/> values are the same. </summary>
        public static bool operator ==(ApiType left, ApiType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApiType"/> values are not the same. </summary>
        public static bool operator !=(ApiType left, ApiType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApiType"/>. </summary>
        public static implicit operator ApiType(string value) => new ApiType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApiType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApiType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
