// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Schema Type. Immutable. </summary>
    public readonly partial struct ApiSchemaType : IEquatable<ApiSchemaType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApiSchemaType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApiSchemaType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string XmlValue = "xml";
        private const string JsonValue = "json";

        /// <summary> XML schema type. </summary>
        public static ApiSchemaType Xml { get; } = new ApiSchemaType(XmlValue);
        /// <summary> Json schema type. </summary>
        public static ApiSchemaType Json { get; } = new ApiSchemaType(JsonValue);
        /// <summary> Determines if two <see cref="ApiSchemaType"/> values are the same. </summary>
        public static bool operator ==(ApiSchemaType left, ApiSchemaType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApiSchemaType"/> values are not the same. </summary>
        public static bool operator !=(ApiSchemaType left, ApiSchemaType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApiSchemaType"/>. </summary>
        public static implicit operator ApiSchemaType(string value) => new ApiSchemaType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApiSchemaType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApiSchemaType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
