// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Summary of revision metadata. </summary>
    public partial class ApiRevisionContract
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApiRevisionContract"/>. </summary>
        internal ApiRevisionContract()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApiRevisionContract"/>. </summary>
        /// <param name="apiId"> Identifier of the API Revision. </param>
        /// <param name="apiRevision"> Revision number of API. </param>
        /// <param name="createdOn"> The time the API Revision was created. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard. </param>
        /// <param name="updatedOn"> The time the API Revision were updated. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard. </param>
        /// <param name="description"> Description of the API Revision. </param>
        /// <param name="privateUriString"> Gateway URL for accessing the non-current API Revision. </param>
        /// <param name="isOnline"> Indicates if API revision is the current api revision. </param>
        /// <param name="isCurrent"> Indicates if API revision is accessible via the gateway. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApiRevisionContract(string apiId, string apiRevision, DateTimeOffset? createdOn, DateTimeOffset? updatedOn, string description, string privateUriString, bool? isOnline, bool? isCurrent, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ApiId = apiId;
            ApiRevision = apiRevision;
            CreatedOn = createdOn;
            UpdatedOn = updatedOn;
            Description = description;
            PrivateUriString = privateUriString;
            IsOnline = isOnline;
            IsCurrent = isCurrent;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Identifier of the API Revision. </summary>
        [WirePath("apiId")]
        public string ApiId { get; }
        /// <summary> Revision number of API. </summary>
        [WirePath("apiRevision")]
        public string ApiRevision { get; }
        /// <summary> The time the API Revision was created. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard. </summary>
        [WirePath("createdDateTime")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The time the API Revision were updated. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard. </summary>
        [WirePath("updatedDateTime")]
        public DateTimeOffset? UpdatedOn { get; }
        /// <summary> Description of the API Revision. </summary>
        [WirePath("description")]
        public string Description { get; }
        /// <summary> Gateway URL for accessing the non-current API Revision. </summary>
        [WirePath("privateUrl")]
        public string PrivateUriString { get; }
        /// <summary> Indicates if API revision is the current api revision. </summary>
        [WirePath("isOnline")]
        public bool? IsOnline { get; }
        /// <summary> Indicates if API revision is accessible via the gateway. </summary>
        [WirePath("isCurrent")]
        public bool? IsCurrent { get; }
    }
}
