// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> The ApiOperationInvokableProtocol. </summary>
    public readonly partial struct ApiOperationInvokableProtocol : IEquatable<ApiOperationInvokableProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApiOperationInvokableProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApiOperationInvokableProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HttpValue = "http";
        private const string HttpsValue = "https";
        private const string WsValue = "ws";
        private const string WssValue = "wss";

        /// <summary> http. </summary>
        public static ApiOperationInvokableProtocol Http { get; } = new ApiOperationInvokableProtocol(HttpValue);
        /// <summary> https. </summary>
        public static ApiOperationInvokableProtocol Https { get; } = new ApiOperationInvokableProtocol(HttpsValue);
        /// <summary> ws. </summary>
        public static ApiOperationInvokableProtocol Ws { get; } = new ApiOperationInvokableProtocol(WsValue);
        /// <summary> wss. </summary>
        public static ApiOperationInvokableProtocol Wss { get; } = new ApiOperationInvokableProtocol(WssValue);
        /// <summary> Determines if two <see cref="ApiOperationInvokableProtocol"/> values are the same. </summary>
        public static bool operator ==(ApiOperationInvokableProtocol left, ApiOperationInvokableProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApiOperationInvokableProtocol"/> values are not the same. </summary>
        public static bool operator !=(ApiOperationInvokableProtocol left, ApiOperationInvokableProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApiOperationInvokableProtocol"/>. </summary>
        public static implicit operator ApiOperationInvokableProtocol(string value) => new ApiOperationInvokableProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApiOperationInvokableProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApiOperationInvokableProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
