// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ApiManagement.Models
{
    internal static partial class ApiManagementSkuCapacityScaleTypeExtensions
    {
        public static string ToSerialString(this ApiManagementSkuCapacityScaleType value) => value switch
        {
            ApiManagementSkuCapacityScaleType.None => "None",
            ApiManagementSkuCapacityScaleType.Automatic => "Automatic",
            ApiManagementSkuCapacityScaleType.Manual => "Manual",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ApiManagementSkuCapacityScaleType value.")
        };

        public static ApiManagementSkuCapacityScaleType ToApiManagementSkuCapacityScaleType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return ApiManagementSkuCapacityScaleType.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Automatic")) return ApiManagementSkuCapacityScaleType.Automatic;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Manual")) return ApiManagementSkuCapacityScaleType.Manual;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ApiManagementSkuCapacityScaleType value.");
        }
    }
}
